function LiveFitAlign(src,~,fig,handles,Spec,Energies,FWHM)

%% Get Handles
Method    = get(handles.FineAlign,'Value');
FitDispOpt = get(handles.FitDispOpt,'Value');

pos       = src.Position;
Ind1      = pos(1);
Ind2      = pos(1)+pos(3);

index1    = find(Energies<=Ind1,1,'last');
index2    = find(Energies>=Ind2,1,'first');
E         = Energies(1,index1:index2);

switch FitDispOpt
    case 1
        FWHM  = mean(FWHM,'all');        
        Spec  = reshape(Spec,[size(Spec,1).*size(Spec,2),size(Spec,3)]);
        Spec  = mean(Spec,1);
        Spec  = Spec/max(Spec,[],2);
    case 2
        FWHM  = mean(FWHM,2);
        Spec  = mean(Spec,2);
        Spec  = reshape(Spec,[size(Spec,1),size(Spec,3)]);
        Spec  = Spec./max(Spec,[],2);
    case 3
        FWHM  = reshape(FWHM,[size(Spec,1).*size(Spec,2),1]);
        Spec  = reshape(Spec,[size(Spec,1).*size(Spec,2),size(Spec,3)]);
        Spec  = Spec./max(Spec,[],2);

end
Peak      = Spec(:,index1:index2);
DiffMult  = str2double(get(handles.DiffMult,'String'));
Width     = str2double(get(handles.Width,'String'));

options   = optimset('Display','off');
Fit       = zeros(size(Spec));
Sigma     = FWHM./(2*sqrt(2.*log(2)));


switch Method
    case 1
        %% Fowler-Nordheim
        parfor i=1:size(Spec,1)
            x           = [ 1 , 0 , 0.4, 0.0825];
            eqn         = @(x) sum((x(1).*exp(-(E-x(2))./abs(x(3)))./(1+exp(-(E-x(2))./abs(x(4)))) -Peak(i,:)).^2);
            x           = fminsearch(eqn,x,options);
            Fit(i,:)     = x(1).*exp(-(Energies-x(2))./abs(x(3)))./(1+exp(-(Energies-x(2))./abs(x(4))));
        end
    case 2
        %% Gauss
        parfor i=1:size(Spec,1)
            x           = [ 1 , 0 ,Sigma(i)];
            eqn         = @(x) sum((x(1).*exp(-((E-x(2))./(sqrt(2).*x(3))).^2) - Peak(i,:)).^2);
            x           = fminsearch(eqn,x,options);
            Fit(i,:)      = x(1).*exp(-((Energies-x(2))./(sqrt(2).*x(3))).^2);
        end
end

fit       = Fit./sum(Spec,2);
spec      = Spec./sum(Spec,2);
res       = (spec-fit)*DiffMult;
ResPos    = res;
ResPos(ResPos<0)=0;
ResNeg    = res;
ResNeg(ResPos>0)=0;
ResPos    = mean(ResPos,1);
ResNeg    = mean(ResNeg,1);
spec      = mean(spec,1);
fit       = mean(fit,1);

%% Plot
figure(fig)
hold on
h = findobj(gca,'type','line');
delete(h);

plot(Energies,spec,'-o','Color','b');
plot(Energies,fit,'Color','m');
plot(Energies,ResPos,'Color','g');
plot(Energies,ResNeg,'Color','r');
plot(Energies,zeros(size(Energies)),'--','Color','k');
legend('Normed mean Spectrum','Fit',['Pos. Difference x',num2str(DiffMult)],['Neg. Difference x',num2str(DiffMult)]);
ylabel('mean Loss probability [a.u.]');
xlabel('Loss energy [eV]');


xlim([-mean(FWHM,'all')*Width/2,mean(FWHM,'all')*Width/2]);
ylim([-max(spec)/2,max(spec).*1.25])

clearvars all

end